#include "General.h"
#include "TimeExpiredCommand.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "gmgame.h"

void Format_Time(time_t t, const char *Format, char *buffer, int Length)
{
	tm* time = new tm;
	memset((void*)time, 0x0, sizeof(time));
	time->tm_hour = (int)t / 3600;
	time->tm_min  = ((int)t % 3600) / 60;
	time->tm_sec = (int)t % 60;
	strftime(buffer, Length, Format, time);
	delete time;
}

void Console(const char *Format, ...)
{
	char buffer[256];
	va_list va;
	_crt_va_start(va, Format);
	vsnprintf(buffer, 256, Format, va);
	va_end(va);

	Console_Input(buffer);
}

TimeExpiredCommand::TimeExpiredCommand()
{
	RegisterEvent(EVENT_CHAT_HOOK,this);
}

TimeExpiredCommand::~TimeExpiredCommand()
{
	UnregisterEvent(EVENT_CHAT_HOOK,this);
}

void Display_Current_Map_Time()
{
	char Buffer[128];

	time_t TimeExpired = (time_t)The_Game()->Get_Game_Duration_S();
	Format_Time(TimeExpired, "%H:%M:%S", Buffer, 128);

	Console("MSG Current Map Time: %s", Buffer);
}

bool TimeExpiredCommand::OnChat(int PlayerID,TextMessageEnum Type,const wchar_t *Message,int recieverID)
{
	if ( (Message[0] == '!') )
	{
		StringClass Msg = Message;

		if ( !Msg.Compare_No_Case("!t") || !Msg.Compare_No_Case("!time") )
		{
			Send_Client_Text(Message, TEXT_MESSAGE_PUBLIC, FALSE, PlayerID, recieverID, true, true);
			Display_Current_Map_Time();			
			return false;
		}

	}
	return true;
}

TimeExpiredCommand timeExpiredCommand;

extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &timeExpiredCommand;
}
